class Level_Beginner expands Mutator config(MonsterMatch);

var config int MaxMonsters;
var bool Initialized, bGameEnded;
var int NumPoints, NavPoint, delay, TotalMonsters;

function PreBeginPlay ()
{
	Super.PreBeginPlay();
	SaveConfig();

	SetTimer(1.0,True);

	AddMutator(Level.Spawn(class'Stats_Beginner'));

}

function PostBeginPlay()
{
local NavigationPoint NP;

	if (Initialized)
		{
		return;
		}
	Initialized = True;

	for (NP = Level.NavigationPointList; NP != None; NP = NP.NextNavigationPoint)
		{
		if (NP.IsA('PathNode'))
			{
			NumPoints++;
			}
		}
}

function bool HandleEndGame()
{
	Super.HandleEndGame();

	bGameEnded = True;

	if (NextMutator != None)
		return (NextMutator.HandleEndGame());
}

function Timer()
{
local Pawn P;
local int NumMonsters;
local MonsterPRI MPRI;

	if ( bGameEnded )
		return;

	if ( Delay <= 0 )
		{
		if ( TotalMonsters < MaxMonsters )
			{
			SpawnMonster();
			}
		Delay = 3;
		}
	else
		Delay--;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if (P.IsA('Monsters'))
			{
			NumMonsters++;
			}
		}

	TotalMonsters = NumMonsters;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if (P.IsA('PlayerPawn'))
			{
			MPRI = MonsterPRI(PlayerPawn(P).PlayerReplicationInfo);
			MPRI.NumMonsters = NumMonsters;
			MPRI.Level = "Beginner";
			}
		}
}

function SpawnMonster()
{
local int PointCount;
local int Dice;

	Dice = Rand(100);
	
	if ( Dice < 30 )		//30%
		SpawnKralies();
	else if ( Dice < 60 )		//30%
		SpawnPupies();
	else if ( Dice < 80 )		//20%
		SpawnFlyers();
	else if ( Dice < 90 )		//10%
		SpawnBruties();
	else if ( Dice < 100 )		//10%
		SpawnSnakes();
}

function SpawnBruties()
{
local NavigationPoint NP;
local Brutie BrutieA, BrutieB;
local int PointCount;
local int Dice;

	Dice = Rand(100);

	NavPoint = Rand(NumPoints);
	for (NP = Level.NavigationPointList; NP != None; NP = NP.NextNavigationPoint)
		{
		if ( NP.IsA('PathNode') )
			{
			if (PointCount == NavPoint)
				{
				if ( Dice < 100 )
					{
					BrutieA = Spawn(Class'Brutie', , , NP.Location);
					if ( BrutieA != None )
						BrutieA.GotoState('Attacking');
					}
				else
					{
					BrutieB = Spawn(Class'Brutie', , , NP.Location);
					if ( BrutieB != None )
						BrutieB.GotoState('Attacking');
					}
				}
			PointCount++;
			}
		}
}

function SpawnSnakes()
{
local NavigationPoint NP;
local Snake SnakeA, SnakeB;
local int PointCount;
local int Dice;

	Dice = Rand(100);

	NavPoint = Rand(NumPoints);
	for (NP = Level.NavigationPointList; NP != None; NP = NP.NextNavigationPoint)
		{
		if ( NP.IsA('PathNode') )
			{
			if (PointCount == NavPoint)
				{
				if ( Dice < 100 )
					{
					SnakeA = Spawn(Class'Snake', , , NP.Location);
					if ( SnakeA != None )
						SnakeA.GotoState('Attacking');
					}
				else
					{
					SnakeB = Spawn(Class'Snake', , , NP.Location);
					if ( SnakeB != None )
						SnakeB.GotoState('Attacking');
					}
				}
			PointCount++;
			}
		}
}

function SpawnFlyers()
{
local NavigationPoint NP;
local Flyer FlyerA, FlyerB;
local int PointCount;
local int Dice;

	Dice = Rand(100);

	NavPoint = Rand(NumPoints);
	for (NP = Level.NavigationPointList; NP != None; NP = NP.NextNavigationPoint)
		{
		if ( NP.IsA('PathNode') )
			{
			if (PointCount == NavPoint)
				{
				if ( Dice < 100 )
					{
					FlyerA = Spawn(Class'Flyer', , , NP.Location);
					if ( FlyerA != None )
						FlyerA.GotoState('Attacking');
					}
				else
					{
					FlyerB = Spawn(Class'Flyer', , , NP.Location);
					if ( FlyerB != None )
						FlyerB.GotoState('Attacking');
					}
				}
			PointCount++;
			}
		}
}

function SpawnPupies()
{
local NavigationPoint NP;
local Pupie PupieA;
local ElitePupie PupieB;
local int PointCount;
local int Dice;

	Dice = Rand(100);

	NavPoint = Rand(NumPoints);
	for (NP = Level.NavigationPointList; NP != None; NP = NP.NextNavigationPoint)
		{
		if ( NP.IsA('PathNode') )
			{
			if (PointCount == NavPoint)
				{
				if ( Dice < 50 )
					{
					PupieA = Spawn(Class'Pupie', , , NP.Location);
					if ( PupieA != None )
						PupieA.GotoState('Attacking');
					}
				else
					{
					PupieB = Spawn(Class'ElitePupie', , , NP.Location);
					if ( PupieB != None )
						PupieB.GotoState('Attacking');
					}
				}
			PointCount++;
			}
		}
}

function SpawnKralies()
{
local NavigationPoint NP;
local Krali KralieA;
local EliteKrali KralieB;
local int PointCount;
local int Dice;

	Dice = Rand(100);

	NavPoint = Rand(NumPoints);
	for (NP = Level.NavigationPointList; NP != None; NP = NP.NextNavigationPoint)
		{
		if ( NP.IsA('PathNode') )
			{
			if (PointCount == NavPoint)
				{
				if ( Dice < 75 )
					{
					KralieA = Spawn(Class'Krali', , , NP.Location);
					if ( KralieA != None )
						KralieA.GotoState('Attacking');
					}
				else
					{
					KralieB = Spawn(Class'EliteKrali', , , NP.Location);
					if ( KralieB != None )
						KralieB.GotoState('Attacking');
					}
				return;
				}
			PointCount++;
			}
		}
}

defaultproperties
{
MaxMonsters=5
NumPoints=0
Delay=3
}